/*
 * Decompiled with CFR 0.152.
 */
package jtbcore.db.parser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class BaseTokenizer {
    public List<String> tokens;

    public List<String> getTokens() {
        return this.tokens;
    }

    public void setTokens(List<String> tokens) {
        this.tokens = tokens;
    }

    protected void removeWhiteTokens() {
        ArrayList<String> l = new ArrayList<String>();
        for (String t : this.tokens) {
            if (t.trim().length() <= 0) continue;
            l.add(t);
        }
        this.tokens = l;
    }

    protected void removeBackticks() {
        int x = 0;
        while (x < this.tokens.size()) {
            String t = this.tokens.get(x);
            if (t.startsWith("`") && t.endsWith("`")) {
                t = t.substring(1, t.length() - 1);
                this.tokens.set(x, t);
            }
            ++x;
        }
    }

    protected String removeBackticks(String t) {
        if (t.length() >= 2 && t.charAt(0) == '`' && t.charAt(t.length() - 1) == '`') {
            return t.substring(1, t.length() - 1);
        }
        if (t.length() >= 2 && t.charAt(0) == '\"' && t.charAt(t.length() - 1) == '\"') {
            return t.substring(1, t.length() - 1);
        }
        if (t.length() >= 2 && t.charAt(0) == '[' && t.charAt(t.length() - 1) == ']') {
            return t.substring(1, t.length() - 1);
        }
        return t;
    }

    protected void addToken(byte[] buf, int len) {
        if (len == 0) {
            return;
        }
        String t = new String(buf, 0, len);
        this.tokens.add(t);
    }

    protected void addToken(byte c) {
        String t = Character.toString(c);
        this.tokens.add(t);
    }

    public void parse(String data) throws IOException {
        this.tokens = new ArrayList<String>();
        State state = new State();
        int dataSize = data.length();
        byte[] bytes = data.getBytes("UTF-8");
        int x = 0;
        while (x < bytes.length) {
            block12: {
                block17: {
                    byte c;
                    block16: {
                        block15: {
                            boolean isWhiteSpace2;
                            block14: {
                                block13: {
                                    block10: {
                                        block11: {
                                            c = bytes[x];
                                            int cfr_ignored_0 = state.len;
                                            state.nextChar = (byte)(x + 1 < bytes.length ? bytes[x + 1] : 32);
                                            state.prevChar = (byte)(x > 0 ? bytes[x - 1] : 32);
                                            if (x > 0 && state.prevChar == 92 && (c == 34 || c == 39 || c == 96)) {
                                                state.escape = true;
                                            }
                                            if (x > 0 && state.prevChar == 39 && c == 39) {
                                                state.escape = true;
                                            }
                                            if (state.inComment || state.inCommentBlock || state.inBlock) break block10;
                                            if (c != 46 && c != 40 && c != 41 && c != 44) break block11;
                                            this.addToken(state.buf, state.len);
                                            state.len = 0;
                                            this.addToken(c);
                                            break block12;
                                        }
                                        if (c == 35 || c == 45 && state.nextChar == 45) {
                                            state.inComment = true;
                                        }
                                        if (c == 47 && state.nextChar == 42) {
                                            state.inCommentBlock = true;
                                        }
                                    }
                                    if (!state.escape) break block13;
                                    state.buf[state.len++] = c;
                                    state.escape = false;
                                    break block12;
                                }
                                if (state.inComment || !(!state.inCommentBlock & !state.inBlock) || c != 34 && c != 39 && c != 96) break block14;
                                state.inBlock = true;
                                state.blockChar = c;
                                this.addToken(state.buf, state.len);
                                state.len = 0;
                                state.buf[state.len++] = c;
                                break block12;
                            }
                            if (state.inComment || !(!state.inCommentBlock & !state.inBlock)) break block15;
                            boolean isWhiteSpace1 = state.prevChar == 32 || state.prevChar == 9 || state.prevChar == 13 || state.prevChar == 10;
                            boolean bl = isWhiteSpace2 = c == 32 || c == 9 || c == 13 || c == 10;
                            if (x <= 0 || isWhiteSpace1 == isWhiteSpace2) break block15;
                            this.addToken(state.buf, state.len);
                            state.len = 0;
                            state.buf[state.len++] = c;
                            break block12;
                        }
                        if (!state.inBlock) break block16;
                        state.buf[state.len++] = c;
                        if (c != state.blockChar) break block17;
                        state.inBlock = false;
                        this.addToken(state.buf, state.len);
                        state.len = 0;
                        break block12;
                    }
                    if (state.inComment || state.inCommentBlock) {
                        state.buf[state.len++] = c;
                        if (state.inComment && c == 10) {
                            this.addToken(state.buf, state.len);
                            state.len = 0;
                            state.inComment = false;
                        }
                        if (state.inCommentBlock && state.prevChar == 42 && c == 47) {
                            this.addToken(state.buf, state.len);
                            state.len = 0;
                            state.inCommentBlock = false;
                        }
                    } else {
                        state.buf[state.len++] = c;
                    }
                }
                state.escape = false;
            }
            ++x;
        }
        if (state.len > 0) {
            this.addToken(state.buf, state.len);
        }
    }

    public static void main(String[] args) {
        String sql = "\t\t\t\tCREATE TABLE `contracts__contract`(\n  `contract_id` int NOT NULL AUTO_INCREMENT,\n  `contract_type_id` int DEFAULT NULL,\n  `company_id` int DEFAULT NULL,\n  `person_id` int DEFAULT NULL,\n  `file_id` int DEFAULT NULL,\n  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,\n  `start_date` date DEFAULT NULL,\n  `end_date` date DEFAULT NULL,\n  `time_notice` int DEFAULT NULL,\n  `time_notice_unit` enum('day','week','month','year') CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,\n  `renew_period` int DEFAULT NULL,\n  `renew_unit` enum('day','week','month','year') CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,\n  `status` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,\n  `note` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,\n  `edited` datetime DEFAULT NULL,\n  `created` datetime DEFAULT NULL,\n  `auto_renew` tinyint(1) DEFAULT NULL,\n  `deleted` datetime DEFAULT NULL,\n  `parent_contract_id` int DEFAULT NULL,\n  `amount_text` varchar( 255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,\n  `renew_date_temp` date DEFAULT NULL,\n  `auto_renew_mail` tinyint(1) DEFAULT '1',\n  PRIMARY KEY (`contract_id`)\n) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci\n";
        try {
            BaseTokenizer t = new BaseTokenizer();
            t.parse(sql);
            for (String string : t.getTokens()) {
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static class State {
        public byte[] buf = new byte[4096];
        public int len = 0;
        public byte prevChar;
        public byte nextChar;
        public boolean inBlock = false;
        public byte blockChar;
        public boolean inComment = false;
        public boolean inCommentBlock = false;
        public boolean escape = false;
    }
}

